---
title: Script Names
---

# Script Names

Languages may be written with different scripts (aka writing systems). For example, Serbian is written in both Cyrillic and Latin script (Cyrillic: српски, Latin: srpski). Chinese is also written in two different script variants: Hant (Traditional) and Hans (Simplified). Script names may thus be used to disambiguate the written forms of languages, such as when listing in a menu. In this case, they'll be separated from the base language name by punctuation, typically parentheses:

- Serbian (Latin)
- Serbian (Cyrillic)
- Chinese (Simplified)
- Chinese (Traditional)

The most important scripts for this purpose are Cyrillic, Arabic, and Latin, plus the special codes Hant (Traditional) and Hans (Simplified).

Scripts may also be listed in a menu by themselves.

For the script names, please follow these guidelines:

- Each of the script names **must** be unique.
- Don't use commas and don't invert the name (eg use "New Tai Lue", not "Tai Lue, New").
- Don't use the characters "(" and ")", since they will be confusing in combination with countries or languages in more complex language names. If you have to use brackets, use square ones: [ and ].
- The most neutral grammatical form for the script that is natural for these two usages should be chosen. If there is no single form that can accomplish that, favor the usage within language names (inside parentheses).
- Use the capitalization that would be appropriate in the middle of a sentence; the \<contextTransforms> data can specify the capitalization for other contexts. For more information, see [Capitalization](/translation/capitalization).

See also [Language Names](/translation/displaynames/languagelocale-names).


