; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals --version 2
; RUN: opt < %s -passes='simplifycfg<no-sink-common-insts;hoist-common-insts>' -simplifycfg-require-and-preserve-domtree=1 -S | FileCheck %s --check-prefix=HOIST

; Test case based on C++ code with manualy annotated !prof metadata.
; This is to test that when calls to 'func1' from 'if.then' block
; and 'if.else' block are hoisted, the branch_weights are merged and
; attached to merged call rather than dropped.
;
; int func1(int a, int b) ;
; int func2(int a, int b) ;

; int func(int a, int b, bool c) {
;    int sum= 0;
;    if(c) {
;        sum += func1(a, b);
;    } else {
;        sum += func1(a, b);
;        sum -= func2(a, b);
;    }
;    return sum;
; }
define i32 @_Z4funciib(i32 %a, i32 %b, i1 %c) {
; HOIST-LABEL: define i32 @_Z4funciib
; HOIST-SAME: (i32 [[A:%.*]], i32 [[B:%.*]], i1 [[C:%.*]]) {
; HOIST-NEXT:  entry:
; HOIST-NEXT:    [[CALL:%.*]] = tail call i32 @_Z5func1ii(i32 [[A]], i32 [[B]]), !prof [[PROF0:![0-9]+]]
; HOIST-NEXT:    br i1 [[C]], label [[IF_END:%.*]], label [[IF_ELSE:%.*]]
; HOIST:       if.else:
; HOIST-NEXT:    [[CALL3:%.*]] = tail call i32 @_Z5func2ii(i32 [[A]], i32 [[B]])
; HOIST-NEXT:    [[SUB:%.*]] = sub i32 [[CALL]], [[CALL3]]
; HOIST-NEXT:    br label [[IF_END]]
; HOIST:       if.end:
; HOIST-NEXT:    [[SUM_0:%.*]] = phi i32 [ [[SUB]], [[IF_ELSE]] ], [ [[CALL]], [[ENTRY:%.*]] ]
; HOIST-NEXT:    ret i32 [[SUM_0]]
;
entry:
  br i1 %c, label %if.then, label %if.else

if.then:                                          ; preds = %entry
  %call = tail call i32 @_Z5func1ii(i32 %a, i32 %b), !prof !0
  br label %if.end

if.else:                                          ; preds = %entry
  %call1 = tail call i32 @_Z5func1ii(i32 %a, i32 %b), !prof !1
  %call3 = tail call i32 @_Z5func2ii(i32 %a, i32 %b)
  %sub = sub i32 %call1, %call3
  br label %if.end

if.end:                                           ; preds = %if.else, %if.then
  %sum.0 = phi i32 [ %call, %if.then ], [ %sub, %if.else ]
  ret i32 %sum.0
}

declare i32 @_Z5func1ii(i32, i32)

declare i32 @_Z5func2ii(i32, i32)

!0 = !{!"branch_weights", i32 10}
!1 = !{!"branch_weights", i32 90}
;.
; HOIST: [[PROF0]] = !{!"branch_weights", i64 100}
;.
