/*
 *  $Id$
 */

#ifndef _MACHINE__DEFAULT_TYPES_H
#define _MACHINE__DEFAULT_TYPES_H

#include <sys/features.h>

/*
 * Guess on types by examining *_MIN / *_MAX defines.
 */
#if __GNUC_PREREQ (3, 3)
/* GCC >= 3.3.0 has __<val>__ implicitly defined. */
#define __EXP(x) __##x##__
#else
/* Fall back to POSIX versions from <limits.h> */
#define __EXP(x) x
#include <limits.h>
#endif

/* Check if "long long" is 64bit wide */
/* Modern GCCs provide __LONG_LONG_MAX__, SUSv3 wants LLONG_MAX */
#if ( defined(__LONG_LONG_MAX__) && (__LONG_LONG_MAX__ > 0x7fffffff) ) \
  || ( defined(LLONG_MAX) && (LLONG_MAX > 0x7fffffff) )
#define __have_longlong64 1
#endif

/* Check if "long" is 64bit or 32bit wide */
#if __EXP(LONG_MAX) > 0x7fffffff
#define __have_long64 1
#elif __EXP(LONG_MAX) == 0x7fffffff && !defined(__SPU__)
#define __have_long32 1
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __INT8_TYPE__
typedef __INT8_TYPE__ __int8_t;
#ifdef __UINT8_TYPE__
typedef __UINT8_TYPE__ __uint8_t;
#else
typedef unsigned __INT8_TYPE__ __uint8_t;
#endif
#define ___int8_t_defined 1
#elif __EXP(SCHAR_MAX) == 0x7f
typedef signed char __int8_t ;
typedef unsigned char __uint8_t ;
#define ___int8_t_defined 1
#endif

#ifdef __INT16_TYPE__
typedef __INT16_TYPE__ __int16_t;
#ifdef __UINT16_TYPE__
typedef __UINT16_TYPE__ __uint16_t;
#else
typedef unsigned __INT16_TYPE__ __uint16_t;
#endif
#define ___int16_t_defined 1
#elif __EXP(INT_MAX) == 0x7fff
typedef signed int __int16_t;
typedef unsigned int __uint16_t;
#define ___int16_t_defined 1
#elif __EXP(SHRT_MAX) == 0x7fff
typedef signed short __int16_t;
typedef unsigned short __uint16_t;
#define ___int16_t_defined 1
#elif __EXP(SCHAR_MAX) == 0x7fff
typedef signed char __int16_t;
typedef unsigned char __uint16_t;
#define ___int16_t_defined 1
#endif

#ifdef __INT32_TYPE__
typedef __INT32_TYPE__ __int32_t;
#ifdef __UINT32_TYPE__
typedef __UINT32_TYPE__ __uint32_t;
#else
typedef unsigned __INT32_TYPE__ __uint32_t;
#endif
#define ___int32_t_defined 1
#elif __EXP(INT_MAX) == 0x7fffffffL
typedef signed int __int32_t;
typedef unsigned int __uint32_t;
#define ___int32_t_defined 1
#elif __EXP(LONG_MAX) == 0x7fffffffL
typedef signed long __int32_t;
typedef unsigned long __uint32_t;
#define ___int32_t_defined 1
#elif __EXP(SHRT_MAX) == 0x7fffffffL
typedef signed short __int32_t;
typedef unsigned short __uint32_t;
#define ___int32_t_defined 1
#elif __EXP(SCHAR_MAX) == 0x7fffffffL
typedef signed char __int32_t;
typedef unsigned char __uint32_t;
#define ___int32_t_defined 1
#endif

#ifdef __INT64_TYPE__
typedef __INT64_TYPE__ __int64_t;
#ifdef __UINT64_TYPE__
typedef __UINT64_TYPE__ __uint64_t;
#else
typedef unsigned __INT64_TYPE__ __uint64_t;
#endif
#define ___int64_t_defined 1
#elif __EXP(LONG_MAX) > 0x7fffffff
typedef signed long __int64_t;
typedef unsigned long __uint64_t;
#define ___int64_t_defined 1

/* GCC has __LONG_LONG_MAX__ */
#elif  defined(__LONG_LONG_MAX__) && (__LONG_LONG_MAX__ > 0x7fffffff)
typedef signed long long __int64_t;
typedef unsigned long long __uint64_t;
#define ___int64_t_defined 1

/* POSIX mandates LLONG_MAX in <limits.h> */
#elif  defined(LLONG_MAX) && (LLONG_MAX > 0x7fffffff)
typedef signed long long __int64_t;
typedef unsigned long long __uint64_t;
#define ___int64_t_defined 1

#elif  __EXP(INT_MAX) > 0x7fffffff
typedef signed int __int64_t;
typedef unsigned int __uint64_t;
#define ___int64_t_defined 1
#endif

#ifdef __INT_LEAST8_TYPE__
typedef __INT_LEAST8_TYPE__ __int_least8_t;
#ifdef __UINT_LEAST8_TYPE__
typedef __UINT_LEAST8_TYPE__ __uint_least8_t;
#else
typedef unsigned __INT_LEAST8_TYPE__ __uint_least8_t;
#endif
#define ___int_least8_t_defined 1
#elif defined(___int8_t_defined)
typedef __int8_t __int_least8_t;
typedef __uint8_t __uint_least8_t;
#define ___int_least8_t_defined 1
#elif defined(___int16_t_defined)
typedef __int16_t __int_least8_t;
typedef __uint16_t __uint_least8_t;
#define ___int_least8_t_defined 1
#elif defined(___int32_t_defined)
typedef __int32_t __int_least8_t;
typedef __uint32_t __uint_least8_t;
#define ___int_least8_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_least8_t;
typedef __uint64_t __uint_least8_t;
#define ___int_least8_t_defined 1
#endif

#ifdef __INT_LEAST16_TYPE__
typedef __INT_LEAST16_TYPE__ __int_least16_t;
#ifdef __UINT_LEAST16_TYPE__
typedef __UINT_LEAST16_TYPE__ __uint_least16_t;
#else
typedef unsigned __INT_LEAST16_TYPE__ __uint_least16_t;
#endif
#define ___int_least16_t_defined 1
#elif defined(___int16_t_defined)
typedef __int16_t __int_least16_t;
typedef __uint16_t __uint_least16_t;
#define ___int_least16_t_defined 1
#elif defined(___int32_t_defined)
typedef __int32_t __int_least16_t;
typedef __uint32_t __uint_least16_t;
#define ___int_least16_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_least16_t;
typedef __uint64_t __uint_least16_t;
#define ___int_least16_t_defined 1
#endif

#ifdef __INT_LEAST32_TYPE__
typedef __INT_LEAST32_TYPE__ __int_least32_t;
#ifdef __UINT_LEAST32_TYPE__
typedef __UINT_LEAST32_TYPE__ __uint_least32_t;
#else
typedef unsigned __INT_LEAST32_TYPE__ __uint_least32_t;
#endif
#define ___int_least32_t_defined 1
#elif defined(___int32_t_defined)
typedef __int32_t __int_least32_t;
typedef __uint32_t __uint_least32_t;
#define ___int_least32_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_least32_t;
typedef __uint64_t __uint_least32_t;
#define ___int_least32_t_defined 1
#endif

#ifdef __INT_LEAST64_TYPE__
typedef __INT_LEAST64_TYPE__ __int_least64_t;
#ifdef __UINT_LEAST64_TYPE__
typedef __UINT_LEAST64_TYPE__ __uint_least64_t;
#else
typedef unsigned __INT_LEAST64_TYPE__ __uint_least64_t;
#endif
#define ___int_least64_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_least64_t;
typedef __uint64_t __uint_least64_t;
#define ___int_least64_t_defined 1
#endif

#ifdef __INT_FAST8_TYPE__
typedef __INT_FAST8_TYPE__ __int_fast8_t;
#ifdef __UINT_FAST8_TYPE__
typedef __UINT_FAST8_TYPE__ __uint_fast8_t;
#else
typedef unsigned __INT_FAST8_TYPE__ __uint_fast8_t;
#endif
#define ___int_fast8_t_defined 1
#elif defined(___int8_t_defined)
typedef __int8_t __int_fast8_t;
typedef __uint8_t __uint_fast8_t;
#define ___int_fast8_t_defined 1
#elif defined(___int16_t_defined)
typedef __int16_t __int_fast8_t;
typedef __uint16_t __uint_fast8_t;
#define ___int_fast8_t_defined 1
#elif defined(___int32_t_defined)
typedef __int32_t __int_fast8_t;
typedef __uint32_t __uint_fast8_t;
#define ___int_fast8_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_fast8_t;
typedef __uint64_t __uint_fast8_t;
#define ___int_fast8_t_defined 1
#endif

#ifdef __INT_FAST16_TYPE__
typedef __INT_FAST16_TYPE__ __int_fast16_t;
#ifdef __UINT_FAST16_TYPE__
typedef __UINT_FAST16_TYPE__ __uint_fast16_t;
#else
typedef unsigned __INT_FAST16_TYPE__ __uint_fast16_t;
#endif
#define ___int_fast16_t_defined 1
#elif defined(___int16_t_defined)
typedef __int16_t __int_fast16_t;
typedef __uint16_t __uint_fast16_t;
#define ___int_fast16_t_defined 1
#elif defined(___int32_t_defined)
typedef __int32_t __int_fast16_t;
typedef __uint32_t __uint_fast16_t;
#define ___int_fast16_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_fast16_t;
typedef __uint64_t __uint_fast16_t;
#define ___int_fast16_t_defined 1
#endif

#ifdef __INT_FAST32_TYPE__
typedef __INT_FAST32_TYPE__ __int_fast32_t;
#ifdef __UINT_FAST32_TYPE__
typedef __UINT_FAST32_TYPE__ __uint_fast32_t;
#else
typedef unsigned __INT_FAST32_TYPE__ __uint_fast32_t;
#endif
#define ___int_fast32_t_defined 1
#elif defined(___int32_t_defined)
typedef __int32_t __int_fast32_t;
typedef __uint32_t __uint_fast32_t;
#define ___int_fast32_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_fast32_t;
typedef __uint64_t __uint_fast32_t;
#define ___int_fast32_t_defined 1
#endif

#ifdef __INT_FAST64_TYPE__
typedef __INT_FAST64_TYPE__ __int_fast64_t;
#ifdef __UINT_FAST64_TYPE__
typedef __UINT_FAST64_TYPE__ __uint_fast64_t;
#else
typedef unsigned __INT_FAST64_TYPE__ __uint_fast64_t;
#endif
#define ___int_fast64_t_defined 1
#elif defined(___int64_t_defined)
typedef __int64_t __int_fast64_t;
typedef __uint64_t __uint_fast64_t;
#define ___int_fast64_t_defined 1
#endif

#if defined(__INTMAX_TYPE__)
typedef __INTMAX_TYPE__ __intmax_t;
#elif __have_longlong64
typedef signed long long __intmax_t;
#else
typedef signed long __intmax_t;
#endif

#if defined(__UINTMAX_TYPE__)
typedef __UINTMAX_TYPE__ __uintmax_t;
#elif __have_longlong64
typedef unsigned long long __uintmax_t;
#else
typedef unsigned long __uintmax_t;
#endif

#ifdef __INTPTR_TYPE__
typedef __INTPTR_TYPE__ __intptr_t;
#ifdef __UINTPTR_TYPE__
typedef __UINTPTR_TYPE__ __uintptr_t;
#else
typedef unsigned __INTPTR_TYPE__ __uintptr_t;
#endif
#elif defined(__PTRDIFF_TYPE__)
typedef __PTRDIFF_TYPE__ __intptr_t;
typedef unsigned __PTRDIFF_TYPE__ __uintptr_t;
#else
typedef long __intptr_t;
typedef unsigned long __uintptr_t;
#endif

#ifdef __PTRDIFF_TYPE__
typedef __PTRDIFF_TYPE__ __ptrdiff_t;
#else
typedef long int __ptrdiff_t;
#endif

#ifdef __WCHAR_TYPE__
typedef __WCHAR_TYPE__ __wchar_t;
#elif defined (__WCHAR_MAX__) && __WCHAR_MAX__ == 0xffff
typedef short unsigned int __wchar_t;
#else
typedef int __wchar_t;
#endif

/* clang already defines these types in C++ mode */
#if !defined(__clang__) || !defined(__cplusplus)
#ifdef __CHAR16_TYPE__
typedef __CHAR16_TYPE__		__char16_t;
#else
typedef __uint_least16_t        __char16_t;
#endif
#ifdef __CHAR32_TYPE__
typedef __CHAR32_TYPE__		__char32_t;
#else
typedef __uint_least32_t        __char32_t;
#endif
#endif

#undef __EXP

#ifdef __cplusplus
}
#endif

#endif /* _MACHINE__DEFAULT_TYPES_H */
