; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=-lzcnt,+sse2 | FileCheck %s -check-prefixes=CHECK,NOLZCNT
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+sse2 | FileCheck %s -check-prefixes=CHECK,LZCNT,SSE2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+sse4.2 | FileCheck %s -check-prefixes=CHECK,LZCNT,SSE42
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+avx | FileCheck %s -check-prefixes=CHECK,LZCNT,AVX1
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+avx2 | FileCheck %s -check-prefixes=CHECK,LZCNT,AVX2
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+avx512f | FileCheck %s -check-prefixes=CHECK,LZCNT,AVX512,AVX512F
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+avx512vl,+avx512bw,+avx512dq | FileCheck %s -check-prefixes=CHECK,LZCNT,AVX512,AVX512BW
; RUN: opt < %s -mtriple=x86_64-unknown-linux-gnu -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=size-latency -mattr=+lzcnt,+avx512vl,+avx512bw,+avx512dq,+avx512cd | FileCheck %s -check-prefixes=CHECK,LZCNT,AVX512CD

; Verify the cost of scalar leading zero count instructions.

declare i64 @llvm.ctlz.i64(i64, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i16 @llvm.ctlz.i16(i16, i1)
declare  i8 @llvm.ctlz.i8(i8, i1)

define i64 @var_ctlz_i64(i64 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i64'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i64'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %ctlz
;
  %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 0)
  ret i64 %ctlz
}

define i64 @var_ctlz_i64u(i64 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i64u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i64u'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i64 %ctlz
;
  %ctlz = call i64 @llvm.ctlz.i64(i64 %a, i1 1)
  ret i64 %ctlz
}

define i32 @var_ctlz_i32(i32 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i32'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i32'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %ctlz
;
  %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 0)
  ret i32 %ctlz
}

define i32 @var_ctlz_i32u(i32 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i32u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i32u'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 %ctlz
;
  %ctlz = call i32 @llvm.ctlz.i32(i32 %a, i1 1)
  ret i32 %ctlz
}

define i16 @var_ctlz_i16(i16 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i16'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i16'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %ctlz
;
  %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 0)
  ret i16 %ctlz
}

define i16 @var_ctlz_i16u(i16 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i16u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i16u'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i16 %ctlz
;
  %ctlz = call i16 @llvm.ctlz.i16(i16 %a, i1 1)
  ret i16 %ctlz
}

define i8 @var_ctlz_i8(i8 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i8'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i8'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 false)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %ctlz
;
  %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 0)
  ret i8 %ctlz
}

define i8 @var_ctlz_i8u(i8 %a) {
; NOLZCNT-LABEL: 'var_ctlz_i8u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %ctlz
;
; LZCNT-LABEL: 'var_ctlz_i8u'
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 true)
; LZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i8 %ctlz
;
  %ctlz = call i8 @llvm.ctlz.i8(i8 %a, i1 1)
  ret i8 %ctlz
}

; Verify the cost of vector leading zero count instructions.

declare <2 x i64> @llvm.ctlz.v2i64(<2 x i64>, i1)
declare <4 x i32> @llvm.ctlz.v4i32(<4 x i32>, i1)
declare <8 x i16> @llvm.ctlz.v8i16(<8 x i16>, i1)
declare <16 x i8> @llvm.ctlz.v16i8(<16 x i8>, i1)

declare <4 x i64> @llvm.ctlz.v4i64(<4 x i64>, i1)
declare <8 x i32> @llvm.ctlz.v8i32(<8 x i32>, i1)
declare <16 x i16> @llvm.ctlz.v16i16(<16 x i16>, i1)
declare <32 x i8> @llvm.ctlz.v32i8(<32 x i8>, i1)

declare <8 x i64> @llvm.ctlz.v8i64(<8 x i64>, i1)
declare <16 x i32> @llvm.ctlz.v16i32(<16 x i32>, i1)
declare <32 x i16> @llvm.ctlz.v32i16(<32 x i16>, i1)
declare <64 x i8> @llvm.ctlz.v64i8(<64 x i8>, i1)

define <2 x i64> @var_ctlz_v2i64(<2 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v2i64'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v2i64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v2i64'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v2i64'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v2i64'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v2i64'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v2i64'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
  %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 0)
  ret <2 x i64> %ctlz
}

define <2 x i64> @var_ctlz_v2i64u(<2 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v2i64u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v2i64u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v2i64u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v2i64u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v2i64u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v2i64u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v2i64u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <2 x i64> %ctlz
;
  %ctlz = call <2 x i64> @llvm.ctlz.v2i64(<2 x i64> %a, i1 1)
  ret <2 x i64> %ctlz
}

define <4 x i64> @var_ctlz_v4i64(<4 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i64'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i64'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 70 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i64'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 58 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i64'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i64'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i64'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
  %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 0)
  ret <4 x i64> %ctlz
}

define <4 x i64> @var_ctlz_v4i64u(<4 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i64u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i64u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i64u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 70 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i64u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 58 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i64u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i64u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i64u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i64> %ctlz
;
  %ctlz = call <4 x i64> @llvm.ctlz.v4i64(<4 x i64> %a, i1 1)
  ret <4 x i64> %ctlz
}

define <8 x i64> @var_ctlz_v8i64(<8 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i64'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 152 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i64'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 152 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i64'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 140 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i64'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 116 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i64'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v8i64'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v8i64'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i64'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
  %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 0)
  ret <8 x i64> %ctlz
}

define <8 x i64> @var_ctlz_v8i64u(<8 x i64> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i64u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 152 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i64u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 152 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i64u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 140 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i64u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 116 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i64u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v8i64u'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v8i64u'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i64u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i64> %ctlz
;
  %ctlz = call <8 x i64> @llvm.ctlz.v8i64(<8 x i64> %a, i1 1)
  ret <8 x i64> %ctlz
}

define <4 x i32> @var_ctlz_v4i32(<4 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i32'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i32'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i32'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
  %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 0)
  ret <4 x i32> %ctlz
}

define <4 x i32> @var_ctlz_v4i32u(<4 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v4i32u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v4i32u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v4i32u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v4i32u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 23 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v4i32u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v4i32u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v4i32u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <4 x i32> %ctlz
;
  %ctlz = call <4 x i32> @llvm.ctlz.v4i32(<4 x i32> %a, i1 1)
  ret <4 x i32> %ctlz
}

define <8 x i32> @var_ctlz_v8i32(<8 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i32'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i32'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i32'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
  %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 0)
  ret <8 x i32> %ctlz
}

define <8 x i32> @var_ctlz_v8i32u(<8 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i32u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i32u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 80 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i32u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i32u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i32u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i32u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i32u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i32> %ctlz
;
  %ctlz = call <8 x i32> @llvm.ctlz.v8i32(<8 x i32> %a, i1 1)
  ret <8 x i32> %ctlz
}

define <16 x i32> @var_ctlz_v16i32(<16 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i32'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v16i32'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v16i32'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i32'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
  %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 0)
  ret <16 x i32> %ctlz
}

define <16 x i32> @var_ctlz_v16i32u(<16 x i32> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i32u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i32u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 160 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i32u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i32u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i32u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v16i32u'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v16i32u'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i32u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i32> %ctlz
;
  %ctlz = call <16 x i32> @llvm.ctlz.v16i32(<16 x i32> %a, i1 1)
  ret <16 x i32> %ctlz
}

define <8 x i16> @var_ctlz_v8i16(<8 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i16'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i16'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i16'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
  %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 0)
  ret <8 x i16> %ctlz
}

define <8 x i16> @var_ctlz_v8i16u(<8 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v8i16u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v8i16u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v8i16u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 22 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v8i16u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v8i16u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v8i16u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v8i16u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <8 x i16> %ctlz
;
  %ctlz = call <8 x i16> @llvm.ctlz.v8i16(<8 x i16> %a, i1 1)
  ret <8 x i16> %ctlz
}

define <16 x i16> @var_ctlz_v16i16(<16 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i16'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i16'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i16'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
  %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 0)
  ret <16 x i16> %ctlz
}

define <16 x i16> @var_ctlz_v16i16u(<16 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i16u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i16u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i16u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 44 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i16u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 38 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i16u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i16u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i16u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i16> %ctlz
;
  %ctlz = call <16 x i16> @llvm.ctlz.v16i16(<16 x i16> %a, i1 1)
  ret <16 x i16> %ctlz
}

define <32 x i16> @var_ctlz_v32i16(<32 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i16'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v32i16'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v32i16'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i16'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
  %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 0)
  ret <32 x i16> %ctlz
}

define <32 x i16> @var_ctlz_v32i16u(<32 x i16> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i16u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i16u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i16u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 88 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i16u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 76 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i16u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v32i16u'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 29 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v32i16u'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i16u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 27 for instruction: %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i16> %ctlz
;
  %ctlz = call <32 x i16> @llvm.ctlz.v32i16(<32 x i16> %a, i1 1)
  ret <32 x i16> %ctlz
}

define <16 x i8> @var_ctlz_v16i8(<16 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i8'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i8'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i8'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
  %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 0)
  ret <16 x i8> %ctlz
}

define <16 x i8> @var_ctlz_v16i8u(<16 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v16i8u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v16i8u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v16i8u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v16i8u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v16i8u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v16i8u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v16i8u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <16 x i8> %ctlz
;
  %ctlz = call <16 x i8> @llvm.ctlz.v16i8(<16 x i8> %a, i1 1)
  ret <16 x i8> %ctlz
}

define <32 x i8> @var_ctlz_v32i8(<32 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i8'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v32i8'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i8'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
  %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 0)
  ret <32 x i8> %ctlz
}

define <32 x i8> @var_ctlz_v32i8u(<32 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v32i8u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v32i8u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v32i8u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v32i8u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v32i8u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX512-LABEL: 'var_ctlz_v32i8u'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v32i8u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <32 x i8> %ctlz
;
  %ctlz = call <32 x i8> @llvm.ctlz.v32i8(<32 x i8> %a, i1 1)
  ret <32 x i8> %ctlz
}

define <64 x i8> @var_ctlz_v64i8(<64 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v64i8'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v64i8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v64i8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v64i8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v64i8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v64i8'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v64i8'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v64i8'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 false)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
  %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 0)
  ret <64 x i8> %ctlz
}

define <64 x i8> @var_ctlz_v64i8u(<64 x i8> %a) {
; NOLZCNT-LABEL: 'var_ctlz_v64i8u'
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; NOLZCNT-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; SSE2-LABEL: 'var_ctlz_v64i8u'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; SSE42-LABEL: 'var_ctlz_v64i8u'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX1-LABEL: 'var_ctlz_v64i8u'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX2-LABEL: 'var_ctlz_v64i8u'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX512F-LABEL: 'var_ctlz_v64i8u'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX512BW-LABEL: 'var_ctlz_v64i8u'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
; AVX512CD-LABEL: 'var_ctlz_v64i8u'
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 true)
; AVX512CD-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret <64 x i8> %ctlz
;
  %ctlz = call <64 x i8> @llvm.ctlz.v64i8(<64 x i8> %a, i1 1)
  ret <64 x i8> %ctlz
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
