; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64 %s -o - | FileCheck %s

declare i32 @g0(i32)
declare i32 @g1(ptr)

define i32 @foo_nounwind(i1 %cmp) nounwind {
; CHECK-LABEL: foo_nounwind:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    sub sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    sub sp, sp, #2688
; CHECK-NEXT:    tbz w0, #0, .LBB0_2
; CHECK-NEXT:  // %bb.1: // %br1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    bl g0
; CHECK-NEXT:    add w0, w0, #1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB0_2: // %br2
; CHECK-NEXT:    mov w8, #42 // =0x2a
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    bl g1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    b g0
  %ptr = alloca i32, i32 100000, align 4
  br i1 %cmp, label %br1, label %br2

br1:
  %call1 = call i32 @g0(i32 0)
  %rv1 = add i32 %call1, 1
  ret i32 %rv1

br2:
  store i32 42, ptr %ptr, align 4
  %call2 = call i32 @g1(ptr %ptr)
  %rv2 = tail call i32 @g0(i32 %call2)
  ret i32 %rv2
}

define i32 @foo_default(i1 %cmp) {
; CHECK-LABEL: foo_default:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    sub sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    sub sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 400016
; CHECK-NEXT:    .cfi_offset w30, -8
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    tbz w0, #0, .LBB1_2
; CHECK-NEXT:  // %bb.1: // %br1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    bl g0
; CHECK-NEXT:    add w0, w0, #1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB1_2: // %br2
; CHECK-NEXT:    mov w8, #42 // =0x2a
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    bl g1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    b g0
  %ptr = alloca i32, i32 100000, align 4
  br i1 %cmp, label %br1, label %br2

br1:
  %call1 = call i32 @g0(i32 0)
  %rv1 = add i32 %call1, 1
  ret i32 %rv1

br2:
  store i32 42, ptr %ptr, align 4
  %call2 = call i32 @g1(ptr %ptr)
  %rv2 = tail call i32 @g0(i32 %call2)
  ret i32 %rv2
}

define i32 @foo_uwtable(i1 %cmp) uwtable {
; CHECK-LABEL: foo_uwtable:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -8
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    sub sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    .cfi_def_cfa_offset 397328
; CHECK-NEXT:    sub sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 400016
; CHECK-NEXT:    .cfi_remember_state
; CHECK-NEXT:    tbz w0, #0, .LBB2_2
; CHECK-NEXT:  // %bb.1: // %br1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    bl g0
; CHECK-NEXT:    add w0, w0, #1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    .cfi_def_cfa_offset 2704
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    .cfi_restore w30
; CHECK-NEXT:    .cfi_restore w29
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB2_2: // %br2
; CHECK-NEXT:    .cfi_restore_state
; CHECK-NEXT:    mov w8, #42 // =0x2a
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    bl g1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    .cfi_def_cfa_offset 2704
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    .cfi_restore w30
; CHECK-NEXT:    .cfi_restore w29
; CHECK-NEXT:    b g0
  %ptr = alloca i32, i32 100000, align 4
  br i1 %cmp, label %br1, label %br2

br1:
  %call1 = call i32 @g0(i32 0)
  %rv1 = add i32 %call1, 1
  ret i32 %rv1

br2:
  store i32 42, ptr %ptr, align 4
  %call2 = call i32 @g1(ptr %ptr)
  %rv2 = tail call i32 @g0(i32 %call2)
  ret i32 %rv2
}

define i32 @foo_uwtable_sync(i1 %cmp) uwtable(sync) {
; CHECK-LABEL: foo_uwtable_sync:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    sub sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    sub sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 400016
; CHECK-NEXT:    .cfi_offset w30, -8
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    tbz w0, #0, .LBB3_2
; CHECK-NEXT:  // %bb.1: // %br1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    bl g0
; CHECK-NEXT:    add w0, w0, #1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB3_2: // %br2
; CHECK-NEXT:    mov w8, #42 // =0x2a
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    bl g1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    b g0
  %ptr = alloca i32, i32 100000, align 4
  br i1 %cmp, label %br1, label %br2

br1:
  %call1 = call i32 @g0(i32 0)
  %rv1 = add i32 %call1, 1
  ret i32 %rv1

br2:
  store i32 42, ptr %ptr, align 4
  %call2 = call i32 @g1(ptr %ptr)
  %rv2 = tail call i32 @g0(i32 %call2)
  ret i32 %rv2
}

define i32 @foo_uwtable_async(i1 %cmp) uwtable(async) {
; CHECK-LABEL: foo_uwtable_async:
; CHECK:       // %bb.0:
; CHECK-NEXT:    stp x29, x30, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -8
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    sub sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    .cfi_def_cfa_offset 397328
; CHECK-NEXT:    sub sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 400016
; CHECK-NEXT:    .cfi_remember_state
; CHECK-NEXT:    tbz w0, #0, .LBB4_2
; CHECK-NEXT:  // %bb.1: // %br1
; CHECK-NEXT:    mov w0, wzr
; CHECK-NEXT:    bl g0
; CHECK-NEXT:    add w0, w0, #1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    .cfi_def_cfa_offset 2704
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    .cfi_restore w30
; CHECK-NEXT:    .cfi_restore w29
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB4_2: // %br2
; CHECK-NEXT:    .cfi_restore_state
; CHECK-NEXT:    mov w8, #42 // =0x2a
; CHECK-NEXT:    mov x0, sp
; CHECK-NEXT:    str w8, [sp]
; CHECK-NEXT:    bl g1
; CHECK-NEXT:    add sp, sp, #97, lsl #12 // =397312
; CHECK-NEXT:    .cfi_def_cfa_offset 2704
; CHECK-NEXT:    add sp, sp, #2688
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    ldp x29, x30, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    .cfi_restore w30
; CHECK-NEXT:    .cfi_restore w29
; CHECK-NEXT:    b g0
  %ptr = alloca i32, i32 100000, align 4
  br i1 %cmp, label %br1, label %br2

br1:
  %call1 = call i32 @g0(i32 0)
  %rv1 = add i32 %call1, 1
  ret i32 %rv1

br2:
  store i32 42, ptr %ptr, align 4
  %call2 = call i32 @g1(ptr %ptr)
  %rv2 = tail call i32 @g0(i32 %call2)
  ret i32 %rv2
}
