; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sve2   < %s | FileCheck %s -check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sve2p2 < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sve,+sme2p2 < %s | FileCheck %s -check-prefix CHECK-2p2

; RUN: llc -mattr=+sme    -force-streaming < %s | FileCheck %s -check-prefixes=CHECK,STREAMING-SVE
; RUN: llc -mattr=+sme2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2
; RUN: llc -mattr=+sme,+sve2p2 -force-streaming < %s | FileCheck %s -check-prefix CHECK-2p2

target triple = "aarch64-linux"

define <vscale x 4 x i32> @test_svrecpe_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svrecpe_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    urecpe z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpe_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    urecpe z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.urecpe.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svrecpe_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svrecpe_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    urecpe z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpe_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    urecpe z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.urecpe.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svrecpe_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svrecpe_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    urecpe z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrecpe_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    urecpe z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrecpe_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    urecpe z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.urecpe.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svrsqrte_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svrsqrte_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ursqrte z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrsqrte_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ursqrte z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ursqrte.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svrsqrte_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svrsqrte_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ursqrte z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrsqrte_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ursqrte z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ursqrte.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svrsqrte_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svrsqrte_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    ursqrte z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svrsqrte_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ursqrte z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svrsqrte_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    ursqrte z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ursqrte.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 16 x i8> @test_svqabs_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svqabs_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqabs z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqabs.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svqabs_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svqabs_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqabs.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svqabs_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; SVE-LABEL: test_svqabs_s8_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqabs z0.b, p0/m, z1.b
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqabs_s8_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.b, #0 // =0x0
; STREAMING-SVE-NEXT:    sqabs z0.b, p0/m, z1.b
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqabs.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svqabs_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svqabs_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqabs z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqabs.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svqabs_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svqabs_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqabs.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svqabs_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; SVE-LABEL: test_svqabs_s16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqabs z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqabs_s16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    sqabs z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqabs.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svqabs_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svqabs_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqabs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqabs.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svqabs_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svqabs_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqabs.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svqabs_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svqabs_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqabs z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqabs_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    sqabs z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqabs.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svqabs_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svqabs_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqabs z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqabs.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svqabs_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svqabs_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqabs.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svqabs_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_svqabs_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqabs z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqabs_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqabs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqabs_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    sqabs z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqabs.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svqneg_s8_x_1(<vscale x 16 x i1> %pg, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svqneg_s8_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqneg z0.b, p0/m, z0.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s8_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.b, p0/z, z0.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqneg.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svqneg_s8_x_2(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svqneg_s8_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s8_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqneg.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svqneg_s8_z(<vscale x 16 x i1> %pg, double %z0, <vscale x 16 x i8> %x) {
; SVE-LABEL: test_svqneg_s8_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqneg z0.b, p0/m, z1.b
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s8_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqneg_s8_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.b, #0 // =0x0
; STREAMING-SVE-NEXT:    sqneg z0.b, p0/m, z1.b
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqneg.nxv16i8(<vscale x 16 x i8> zeroinitializer, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svqneg_s16_x_1(<vscale x 8 x i1> %pg, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svqneg_s16_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqneg z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s16_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.h, p0/z, z0.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqneg.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svqneg_s16_x_2(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svqneg_s16_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s16_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqneg.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svqneg_s16_z(<vscale x 8 x i1> %pg, double %z0, <vscale x 8 x i16> %x) {
; SVE-LABEL: test_svqneg_s16_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqneg z0.h, p0/m, z1.h
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s16_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqneg_s16_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    sqneg z0.h, p0/m, z1.h
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqneg.nxv8i16(<vscale x 8 x i16> zeroinitializer, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svqneg_s32_x_1(<vscale x 4 x i1> %pg, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svqneg_s32_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqneg z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s32_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.s, p0/z, z0.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqneg.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svqneg_s32_x_2(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svqneg_s32_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s32_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqneg.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svqneg_s32_z(<vscale x 4 x i1> %pg, double %z0, <vscale x 4 x i32> %x) {
; SVE-LABEL: test_svqneg_s32_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqneg z0.s, p0/m, z1.s
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s32_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqneg_s32_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.s, #0 // =0x0
; STREAMING-SVE-NEXT:    sqneg z0.s, p0/m, z1.s
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqneg.nxv4i32(<vscale x 4 x i32> zeroinitializer, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svqneg_s64_x_1(<vscale x 2 x i1> %pg, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svqneg_s64_x_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sqneg z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s64_x_1:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.d, p0/z, z0.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqneg.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svqneg_s64_x_2(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svqneg_s64_x_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s64_x_2:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqneg.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svqneg_s64_z(<vscale x 2 x i1> %pg, double %z0, <vscale x 2 x i64> %x) {
; SVE-LABEL: test_svqneg_s64_z:
; SVE:       // %bb.0: // %entry
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    sqneg z0.d, p0/m, z1.d
; SVE-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svqneg_s64_z:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    sqneg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
;
; STREAMING-SVE-LABEL: test_svqneg_s64_z:
; STREAMING-SVE:       // %bb.0: // %entry
; STREAMING-SVE-NEXT:    mov z0.d, #0 // =0x0
; STREAMING-SVE-NEXT:    sqneg z0.d, p0/m, z1.d
; STREAMING-SVE-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqneg.nxv2i64(<vscale x 2 x i64> zeroinitializer, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 4 x i32> @test_svurecpe_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svurecpe_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    urecpe z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svurecpe_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    urecpe z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.urecpe.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svurecpe_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svurecpe_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    urecpe z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svurecpe_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    urecpe z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.urecpe.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svursqrte_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svursqrte_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ursqrte z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svursqrte_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    ursqrte z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ursqrte.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svursqrte_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svursqrte_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    ursqrte z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svursqrte_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    ursqrte z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.ursqrte.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 16 x i8> @test_svsqabs_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svsqabs_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    sqabs z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqabs.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svsqabs_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svsqabs_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqabs z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    sqabs z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqabs.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svsqabs_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svsqabs_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    sqabs z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqabs.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svsqabs_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svsqabs_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqabs z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    sqabs z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqabs.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svsqabs_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svsqabs_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    sqabs z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqabs.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svsqabs_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svsqabs_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqabs z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    sqabs z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqabs.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svsqabs_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svsqabs_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqabs z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    sqabs z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqabs.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svsqabs_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svsqabs_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqabs z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqabs_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    sqabs z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqabs.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}

define <vscale x 16 x i8> @test_svsqneg_nxv16i8_ptrue_u(double %z0, <vscale x 16 x i8> %x) {
; CHECK-LABEL: test_svsqneg_nxv16i8_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.b, p0/m, z1.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv16i8_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    sqneg z0.b, p0/z, z1.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqneg.nxv16i8(<vscale x 16 x i8> poison, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %x)
  ret <vscale x 16 x i8> %0
}

define <vscale x 16 x i8> @test_svsqneg_nxv16i8_ptrue(double %z0, <vscale x 16 x i8> %x, <vscale x 16 x i8> %y) {
; CHECK-LABEL: test_svsqneg_nxv16i8_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.b
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqneg z0.b, p0/m, z2.b
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv16i8_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.b
; CHECK-2p2-NEXT:    sqneg z0.b, p0/z, z2.b
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 16 x i1> @llvm.aarch64.sve.ptrue.nxv16i1(i32 31)
  %0 = tail call <vscale x 16 x i8> @llvm.aarch64.sve.sqneg.nxv16i8(<vscale x 16 x i8> %x, <vscale x 16 x i1> %pg, <vscale x 16 x i8> %y)
  ret <vscale x 16 x i8> %0
}

define <vscale x 8 x i16> @test_svsqneg_nxv8i16_ptrue_u(double %z0, <vscale x 8 x i16> %x) {
; CHECK-LABEL: test_svsqneg_nxv8i16_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.h, p0/m, z1.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv8i16_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    sqneg z0.h, p0/z, z1.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqneg.nxv8i16(<vscale x 8 x i16> poison, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %x)
  ret <vscale x 8 x i16> %0
}

define <vscale x 8 x i16> @test_svsqneg_nxv8i16_ptrue(double %z0, <vscale x 8 x i16> %x, <vscale x 8 x i16> %y) {
; CHECK-LABEL: test_svsqneg_nxv8i16_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqneg z0.h, p0/m, z2.h
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv8i16_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.h
; CHECK-2p2-NEXT:    sqneg z0.h, p0/z, z2.h
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 8 x i1> @llvm.aarch64.sve.ptrue.nxv8i1(i32 31)
  %0 = tail call <vscale x 8 x i16> @llvm.aarch64.sve.sqneg.nxv8i16(<vscale x 8 x i16> %x, <vscale x 8 x i1> %pg, <vscale x 8 x i16> %y)
  ret <vscale x 8 x i16> %0
}

define <vscale x 4 x i32> @test_svsqneg_nxv4i32_ptrue_u(double %z0, <vscale x 4 x i32> %x) {
; CHECK-LABEL: test_svsqneg_nxv4i32_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.s, p0/m, z1.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv4i32_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    sqneg z0.s, p0/z, z1.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqneg.nxv4i32(<vscale x 4 x i32> poison, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %x)
  ret <vscale x 4 x i32> %0
}

define <vscale x 4 x i32> @test_svsqneg_nxv4i32_ptrue(double %z0, <vscale x 4 x i32> %x, <vscale x 4 x i32> %y) {
; CHECK-LABEL: test_svsqneg_nxv4i32_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqneg z0.s, p0/m, z2.s
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv4i32_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.s
; CHECK-2p2-NEXT:    sqneg z0.s, p0/z, z2.s
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 4 x i1> @llvm.aarch64.sve.ptrue.nxv4i1(i32 31)
  %0 = tail call <vscale x 4 x i32> @llvm.aarch64.sve.sqneg.nxv4i32(<vscale x 4 x i32> %x, <vscale x 4 x i1> %pg, <vscale x 4 x i32> %y)
  ret <vscale x 4 x i32> %0
}

define <vscale x 2 x i64> @test_svsqneg_nxv2i64_ptrue_u(double %z0, <vscale x 2 x i64> %x) {
; CHECK-LABEL: test_svsqneg_nxv2i64_ptrue_u:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    sqneg z0.d, p0/m, z1.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv2i64_ptrue_u:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    sqneg z0.d, p0/z, z1.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqneg.nxv2i64(<vscale x 2 x i64> poison, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %x)
  ret <vscale x 2 x i64> %0
}

define <vscale x 2 x i64> @test_svsqneg_nxv2i64_ptrue(double %z0, <vscale x 2 x i64> %x, <vscale x 2 x i64> %y) {
; CHECK-LABEL: test_svsqneg_nxv2i64_ptrue:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    sqneg z0.d, p0/m, z2.d
; CHECK-NEXT:    ret
;
; CHECK-2p2-LABEL: test_svsqneg_nxv2i64_ptrue:
; CHECK-2p2:       // %bb.0: // %entry
; CHECK-2p2-NEXT:    ptrue p0.d
; CHECK-2p2-NEXT:    sqneg z0.d, p0/z, z2.d
; CHECK-2p2-NEXT:    ret
entry:
  %pg = call <vscale x 2 x i1> @llvm.aarch64.sve.ptrue.nxv2i1(i32 31)
  %0 = tail call <vscale x 2 x i64> @llvm.aarch64.sve.sqneg.nxv2i64(<vscale x 2 x i64> %x, <vscale x 2 x i1> %pg, <vscale x 2 x i64> %y)
  ret <vscale x 2 x i64> %0
}
