; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt < %s -passes=argpromotion -S | FileCheck %s

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

%union.u = type { x86_fp80 }
%struct.s = type { double, i16, i8, [5 x i8] }

@b = internal global %struct.s { double 3.14, i16 9439, i8 25, [5 x i8] poison }, align 16

%struct.Foo = type { i32, i64 }
@a = internal global %struct.Foo { i32 1, i64 2 }, align 8

define void @run() {
; CHECK-LABEL: define {{[^@]+}}@run() {
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr i8, ptr @b, i64 10
; CHECK-NEXT:    [[B_VAL:%.*]] = load i8, ptr [[TMP1]], align 1
; CHECK-NEXT:    [[TMP2:%.*]] = tail call i8 @UseLongDoubleUnsafely(i8 [[B_VAL]])
; CHECK-NEXT:    [[B_VAL1:%.*]] = load x86_fp80, ptr @b, align 16
; CHECK-NEXT:    [[TMP3:%.*]] = tail call x86_fp80 @UseLongDoubleSafely(x86_fp80 [[B_VAL1]])
; CHECK-NEXT:    [[TMP4:%.*]] = tail call x86_fp80 @UseLongDoubleSafelyNoPromotion(ptr byval([[UNION_U:%.*]]) align 16 @b)
; CHECK-NEXT:    [[A_VAL:%.*]] = load i64, ptr @a, align 8
; CHECK-NEXT:    [[TMP5:%.*]] = call i64 @AccessPaddingOfStruct(i64 [[A_VAL]])
; CHECK-NEXT:    [[TMP6:%.*]] = call i64 @CaptureAStruct(ptr byval([[STRUCT_FOO:%.*]]) @a)
; CHECK-NEXT:    ret void
;
  tail call i8 @UseLongDoubleUnsafely(ptr byval(%union.u) align 16 @b)
  tail call x86_fp80 @UseLongDoubleSafely(ptr byval(%union.u) align 16 @b)
  tail call x86_fp80 @UseLongDoubleSafelyNoPromotion(ptr byval(%union.u) align 16 @b)
  call i64 @AccessPaddingOfStruct(ptr byval(%struct.Foo) @a)
  call i64 @CaptureAStruct(ptr byval(%struct.Foo) @a)
  ret void
}

define internal i8 @UseLongDoubleUnsafely(ptr byval(%union.u) align 16 %arg) {
; CHECK-LABEL: define {{[^@]+}}@UseLongDoubleUnsafely
; CHECK-SAME: (i8 [[ARG_10_VAL:%.*]]) {
; CHECK-NEXT:    ret i8 [[ARG_10_VAL]]
;
  %gep = getelementptr inbounds %struct.s, ptr %arg, i64 0, i32 2
  %result = load i8, ptr %gep
  ret i8 %result
}

define internal x86_fp80 @UseLongDoubleSafely(ptr byval(%union.u) align 16 %arg) {
; CHECK-LABEL: define {{[^@]+}}@UseLongDoubleSafely
; CHECK-SAME: (x86_fp80 [[ARG_0_VAL:%.*]]) {
; CHECK-NEXT:    ret x86_fp80 [[ARG_0_VAL]]
;
  %fp80 = load x86_fp80, ptr %arg
  ret x86_fp80 %fp80
}

define internal x86_fp80 @UseLongDoubleSafelyNoPromotion(ptr byval(%union.u) align 16 %arg) {
; CHECK-LABEL: define {{[^@]+}}@UseLongDoubleSafelyNoPromotion
; CHECK-SAME: (ptr byval([[UNION_U:%.*]]) align 16 [[ARG:%.*]]) {
; CHECK-NEXT:    [[IDX_SLOT:%.*]] = alloca i64, align 8
; CHECK-NEXT:    store i64 0, ptr [[IDX_SLOT]], align 8
; CHECK-NEXT:    [[IDX:%.*]] = load i64, ptr [[IDX_SLOT]], align 8
; CHECK-NEXT:    [[GEP_IDX:%.*]] = getelementptr inbounds [[UNION_U]], ptr [[ARG]], i64 [[IDX]], i32 0
; CHECK-NEXT:    [[FP80:%.*]] = load x86_fp80, ptr [[ARG]], align 16
; CHECK-NEXT:    ret x86_fp80 [[FP80]]
;
  %idx_slot = alloca i64, align 8
  store i64 0, ptr %idx_slot, align 8
  %idx = load i64, ptr %idx_slot, align 8
  %gep_idx = getelementptr inbounds %union.u, ptr %arg, i64 %idx, i32 0 ; to protect from promotion
  %fp80 = load x86_fp80, ptr %arg
  ret x86_fp80 %fp80
}

define internal i64 @AccessPaddingOfStruct(ptr byval(%struct.Foo) %a) {
; CHECK-LABEL: define {{[^@]+}}@AccessPaddingOfStruct
; CHECK-SAME: (i64 [[A_0_VAL:%.*]]) {
; CHECK-NEXT:    ret i64 [[A_0_VAL]]
;
  %v = load i64, ptr %a
  ret i64 %v
}

define internal i64 @CaptureAStruct(ptr byval(%struct.Foo) %a) {
; CHECK-LABEL: define {{[^@]+}}@CaptureAStruct
; CHECK-SAME: (ptr byval([[STRUCT_FOO:%.*]]) [[A:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[A_PTR:%.*]] = alloca ptr, align 8
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[PHI:%.*]] = phi ptr [ null, [[ENTRY:%.*]] ], [ [[A]], [[LOOP]] ]
; CHECK-NEXT:    [[TMP0:%.*]] = phi ptr [ [[A]], [[ENTRY]] ], [ [[TMP0]], [[LOOP]] ]
; CHECK-NEXT:    store ptr [[PHI]], ptr [[A_PTR]], align 8
; CHECK-NEXT:    br label [[LOOP]]
;
entry:
  %a_ptr = alloca ptr
  br label %loop

loop:
  %phi = phi ptr [ null, %entry ], [ %a, %loop ]
  %0   = phi ptr [ %a, %entry ],   [ %0, %loop ]
  store ptr %phi, ptr %a_ptr
  br label %loop
}
