; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define double @std_cabs(double %real, double %imag) {
; CHECK-LABEL: @std_cabs(
; CHECK-NEXT:    [[CALL:%.*]] = tail call double @cabs(double [[REAL:%.*]], double [[IMAG:%.*]])
; CHECK-NEXT:    ret double [[CALL]]
;
  %call = tail call double @cabs(double %real, double %imag)
  ret double %call
}

define float @std_cabsf(float %real, float %imag) {
; CHECK-LABEL: @std_cabsf(
; CHECK-NEXT:    [[CALL:%.*]] = tail call float @cabsf(float [[REAL:%.*]], float [[IMAG:%.*]])
; CHECK-NEXT:    ret float [[CALL]]
;
  %call = tail call float @cabsf(float %real, float %imag)
  ret float %call
}

define fp128 @std_cabsl(fp128 %real, fp128 %imag) {
; CHECK-LABEL: @std_cabsl(
; CHECK-NEXT:    [[CALL:%.*]] = tail call fp128 @cabsl(fp128 [[REAL:%.*]], fp128 [[IMAG:%.*]])
; CHECK-NEXT:    ret fp128 [[CALL]]
;
  %call = tail call fp128 @cabsl(fp128 %real, fp128 %imag)
  ret fp128 %call
}

define double @fast_cabs(double %real, double %imag) {
; CHECK-LABEL: @fast_cabs(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast double [[REAL:%.*]], [[REAL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast double [[IMAG:%.*]], [[IMAG]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast double [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast double @llvm.sqrt.f64(double [[TMP3]])
; CHECK-NEXT:    ret double [[CABS]]
;
  %call = tail call fast double @cabs(double %real, double %imag)
  ret double %call
}

define double @cabs_zero_real(double %imag) {
; CHECK-LABEL: @cabs_zero_real(
; CHECK-NEXT:    [[CABS:%.*]] = tail call double @llvm.fabs.f64(double [[IMAG:%.*]])
; CHECK-NEXT:    ret double [[CABS]]
;
  %call = tail call double @cabs(double 0.0, double %imag)
  ret double %call
}

define double @fast_cabs_neg_zero_real(double %imag) {
; CHECK-LABEL: @fast_cabs_neg_zero_real(
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast double @llvm.fabs.f64(double [[IMAG:%.*]])
; CHECK-NEXT:    ret double [[CABS]]
;
  %call = tail call fast double @cabs(double -0.0, double %imag)
  ret double %call
}

define double @cabs_zero_imag(double %real) {
; CHECK-LABEL: @cabs_zero_imag(
; CHECK-NEXT:    [[CABS:%.*]] = tail call double @llvm.fabs.f64(double [[REAL:%.*]])
; CHECK-NEXT:    ret double [[CABS]]
;
  %call = tail call double @cabs(double %real, double 0.0)
  ret double %call
}

define float @fast_cabsf(float %real, float %imag) {
; CHECK-LABEL: @fast_cabsf(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast float [[REAL:%.*]], [[REAL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast float [[IMAG:%.*]], [[IMAG]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast float [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast float @llvm.sqrt.f32(float [[TMP3]])
; CHECK-NEXT:    ret float [[CABS]]
;
  %call = tail call fast float @cabsf(float %real, float %imag)
  ret float %call
}

define float @cabsf_zero_real(float %imag) {
; CHECK-LABEL: @cabsf_zero_real(
; CHECK-NEXT:    [[CABS:%.*]] = tail call float @llvm.fabs.f32(float [[IMAG:%.*]])
; CHECK-NEXT:    ret float [[CABS]]
;
  %call = tail call float @cabsf(float 0.0, float %imag)
  ret float %call
}

define float @fast_cabsf_neg_zero_real(float %imag) {
; CHECK-LABEL: @fast_cabsf_neg_zero_real(
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast float @llvm.fabs.f32(float [[IMAG:%.*]])
; CHECK-NEXT:    ret float [[CABS]]
;
  %call = tail call fast float @cabsf(float -0.0, float %imag)
  ret float %call
}

define float @cabsf_zero_imag(float %real) {
; CHECK-LABEL: @cabsf_zero_imag(
; CHECK-NEXT:    [[CABS:%.*]] = tail call float @llvm.fabs.f32(float [[REAL:%.*]])
; CHECK-NEXT:    ret float [[CABS]]
;
  %call = tail call float @cabsf(float %real, float 0.0)
  ret float %call
}

define fp128 @fast_cabsl(fp128 %real, fp128 %imag) {
; CHECK-LABEL: @fast_cabsl(
; CHECK-NEXT:    [[TMP1:%.*]] = fmul fast fp128 [[REAL:%.*]], [[REAL]]
; CHECK-NEXT:    [[TMP2:%.*]] = fmul fast fp128 [[IMAG:%.*]], [[IMAG]]
; CHECK-NEXT:    [[TMP3:%.*]] = fadd fast fp128 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast fp128 @llvm.sqrt.f128(fp128 [[TMP3]])
; CHECK-NEXT:    ret fp128 [[CABS]]
;
  %call = tail call fast fp128 @cabsl(fp128 %real, fp128 %imag)
  ret fp128 %call
}

define fp128 @cabsl_zero_real(fp128 %imag) {
; CHECK-LABEL: @cabsl_zero_real(
; CHECK-NEXT:    [[CABS:%.*]] = tail call fp128 @llvm.fabs.f128(fp128 [[IMAG:%.*]])
; CHECK-NEXT:    ret fp128 [[CABS]]
;
  %call = tail call fp128 @cabsl(fp128 0xL00000000000000000000000000000000, fp128 %imag)
  ret fp128 %call
}

define fp128 @cabsl_zero_imag(fp128 %real) {
; CHECK-LABEL: @cabsl_zero_imag(
; CHECK-NEXT:    [[CABS:%.*]] = tail call fp128 @llvm.fabs.f128(fp128 [[REAL:%.*]])
; CHECK-NEXT:    ret fp128 [[CABS]]
;
  %call = tail call fp128 @cabsl(fp128 %real, fp128 0xL00000000000000000000000000000000)
  ret fp128 %call
}

define fp128 @fast_cabsl_neg_zero_imag(fp128 %real) {
; CHECK-LABEL: @fast_cabsl_neg_zero_imag(
; CHECK-NEXT:    [[CABS:%.*]] = tail call fast fp128 @llvm.fabs.f128(fp128 [[REAL:%.*]])
; CHECK-NEXT:    ret fp128 [[CABS]]
;
  %call = tail call fast fp128 @cabsl(fp128 %real, fp128 0xL00000000000000008000000000000000)
  ret fp128 %call
}

declare double @cabs(double %real, double %imag)
declare float @cabsf(float %real, float %imag)
declare fp128 @cabsl(fp128 %real, fp128 %imag)
