; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_100a -mattr=+ptx86 | FileCheck %s
; RUN: %if ptxas-12.8 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_100a -mattr=+ptx86 | %ptxas-verify -arch=sm_100a %}

declare float @llvm.nvvm.redux.sync.fmin(float, i32)
define float @redux_sync_fmin(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmin(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmin_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmin_param_1];
; CHECK-NEXT:    redux.sync.min.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmin(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmin.abs(float, i32)
define float @redux_sync_fmin_abs(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmin_abs(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmin_abs_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmin_abs_param_1];
; CHECK-NEXT:    redux.sync.min.abs.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmin.abs(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmin.NaN(float, i32)
define float @redux_sync_fmin_NaN(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmin_NaN(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmin_NaN_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmin_NaN_param_1];
; CHECK-NEXT:    redux.sync.min.NaN.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmin.NaN(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmin.abs.NaN(float, i32)
define float @redux_sync_fmin_abs_NaN(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmin_abs_NaN(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmin_abs_NaN_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmin_abs_NaN_param_1];
; CHECK-NEXT:    redux.sync.min.abs.NaN.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmin.abs.NaN(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmax(float, i32)
define float @redux_sync_fmax(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmax(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmax_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmax_param_1];
; CHECK-NEXT:    redux.sync.max.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmax(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmax.abs(float, i32)
define float @redux_sync_fmax_abs(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmax_abs(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmax_abs_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmax_abs_param_1];
; CHECK-NEXT:    redux.sync.max.abs.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmax.abs(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmax.NaN(float, i32)
define float @redux_sync_fmax_NaN(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmax_NaN(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmax_NaN_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmax_NaN_param_1];
; CHECK-NEXT:    redux.sync.max.NaN.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmax.NaN(float %src, i32 %mask)
  ret float %val
}

declare float @llvm.nvvm.redux.sync.fmax.abs.NaN(float, i32)
define float @redux_sync_fmax_abs_NaN(float %src, i32 %mask) {
; CHECK-LABEL: redux_sync_fmax_abs_NaN(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [redux_sync_fmax_abs_NaN_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [redux_sync_fmax_abs_NaN_param_1];
; CHECK-NEXT:    redux.sync.max.abs.NaN.f32 %r3, %r1, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call float @llvm.nvvm.redux.sync.fmax.abs.NaN(float %src, i32 %mask)
  ret float %val
}
